function [wt,pk] = testH(e,x)
% Implement heteroscedasticity test using the White test and the Parker test.

y = e.^2;

x = x-mean(x);
xx = ones(size(x));
for i = 1:15
    xx = [xx,x.^i];
    p = (xx'*xx)\(xx'*y);
    ey = xx*p;
    wt.r2(i) = 1-(var(y-ey)/var(y));
    wt.p(i) = 1-chi2cdf(length(x)*wt.r2(i),i);
end

x = x-min(x)+1;
y = log(y);
xx = ones(size(x));
xx = [xx,log(x)];
p = (xx'*xx)\(xx'*y);
st = sum((y-xx*p).^2)/(length(x)-2);
st = (st/sum((log(x)).^2))^.5;
pk.b = p(2);
pk.p = 1-normcdf(p(2)/st);
    
